<?php
require __DIR__.'/../config/db.php';
require __DIR__.'/../config/auth.php';
require_login(); require_role(['driver']);

$u = user();
$driverId = $pdo->query("SELECT id FROM drivers WHERE user_id={$u['id']}")->fetchColumn();

$rows = $pdo->query("
SELECT a.id assignment_id, r.*
FROM ride_assignments a
JOIN ride_requests r ON r.id=a.ride_request_id
WHERE a.driver_id={$driverId}
ORDER BY r.pickup_time DESC")->fetchAll();
?>
<!doctype html><html><head><meta charset="utf-8"><title>Tugas Driver</title>
<link rel="stylesheet" href="/assets/style.css">
</head><body>
<header>
  <h2>Tugas Saya</h2>
  <nav>
    <a href="/index.php">Home</a>
  </nav>
</header>
<div class="card">
<?php foreach($rows as $r): ?>
  <div style="border:1px solid #eee;padding:10px;border-radius:10px;margin-bottom:10px">
    <b>#<?=htmlspecialchars($r['id'])?></b> | <?=$r['vehicle_type']?> | <?=$r['pickup_time']?><br>
    Pickup: <?=$r['pickup_lat']?>, <?=$r['pickup_lon']?> (<?=htmlspecialchars($r['pickup_poi'])?>)<br>
    Drop:   <?=$r['drop_lat']?>, <?=$r['drop_lon']?> (<?=htmlspecialchars($r['drop_poi'])?>)<br>
    Penumpang: <?=htmlspecialchars($r['passenger_name'])?><br>
    Status: <?=$r['status']?><br><br>

    <form method="post" action="/api/driver_accept.php" style="display:inline">
      <input type="hidden" name="assignment_id" value="<?=$r['assignment_id']?>">
      <button>Accept</button>
    </form>

    <form method="post" action="/api/driver_decline.php" style="display:inline">
      <input type="hidden" name="assignment_id" value="<?=$r['assignment_id']?>">
      <button>Decline</button>
    </form>

    <form method="post" action="/api/trip_start.php" style="display:inline"
      onsubmit="return withGeo(this)">
      <input type="hidden" name="ride_request_id" value="<?=$r['id']?>">
      <input type="hidden" name="lat">
      <input type="hidden" name="lon">
      <button>Start</button>
    </form>

    <form method="post" action="/api/trip_finish.php" style="display:inline"
      onsubmit="return withGeo(this)">
      <input type="hidden" name="ride_request_id" value="<?=$r['id']?>">
      <input type="hidden" name="lat">
      <input type="hidden" name="lon">
      <button>Finish</button>
    </form>
  </div>
<?php endforeach; ?>
</div>

<script>
function withGeo(form){
  if (!navigator.geolocation) { alert('No GPS'); return false; }
  navigator.geolocation.getCurrentPosition(pos=>{
    form.querySelector('input[name=lat]').value = pos.coords.latitude;
    form.querySelector('input[name=lon]').value = pos.coords.longitude;
    form.submit();
  }, _=>{ alert('Tidak bisa ambil lokasi'); });
  return false;
}
</script>
</body></html>
