<?php
header('Content-Type: application/json');
require __DIR__ . '/../config/db.php';
require __DIR__ . '/../config/auth.php';
require_login();

$u = user();
$vehicleType = $_POST['vehicle_type'] ?? '';
$pickupTime  = $_POST['pickup_time'] ?? '';
$pickupLat   = floatval($_POST['pickup_lat'] ?? 0);
$pickupLon   = floatval($_POST['pickup_lon'] ?? 0);
$pickupPOI   = $_POST['pickup_poi'] ?? null;
$dropLat     = floatval($_POST['drop_lat'] ?? 0);
$dropLon     = floatval($_POST['drop_lon'] ?? 0);
$dropPOI     = $_POST['drop_poi'] ?? null;
$passenger   = $_POST['passenger_name'] ?? '';
$notes       = $_POST['notes'] ?? null;

if (!in_array($vehicleType, ['MPV_MID','MPV_ECO','SUV_ECO'], true)
    || abs($pickupLat) > 90 || abs($pickupLon) > 180
    || abs($dropLat) > 90 || abs($dropLon) > 180
    || !$passenger || !$pickupTime) {
  http_response_code(400);
  echo json_encode(['ok'=>false,'error'=>'invalid payload']); exit;
}

$stmt = $pdo->prepare("INSERT INTO ride_requests
  (requester_id, org_unit_id, vehicle_type, pickup_time,
   pickup_lat, pickup_lon, pickup_poi, drop_lat, drop_lon, drop_poi, passenger_name, notes)
  VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
$stmt->execute([
  $u['id'], $u['org_unit_id'], $vehicleType, $pickupTime,
  $pickupLat, $pickupLon, $pickupPOI, $dropLat, $dropLon, $dropPOI, $passenger, $notes
]);
echo json_encode(['ok'=>true,'request_id'=>$pdo->lastInsertId()]);
